/*
 * Decompiled with CFR 0.152.
 */
package java.awt.peer;

import java.awt.AWTEvent;
import java.awt.BDToolkit;
import java.awt.BufferCapabilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.PaintEvent;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.VolatileImage;
import java.awt.peer.ComponentPeer;
import java.awt.peer.ContainerPeer;
import org.videolan.Logger;
import sun.java2d.pipe.Region;

public abstract class BDComponentPeer
implements ComponentPeer {
    protected Component component;
    protected Toolkit toolkit;
    protected Point location = new Point();
    protected Dimension size = new Dimension();
    private static final Logger logger = Logger.getLogger((String)BDComponentPeer.class.getName());

    public BDComponentPeer(Toolkit toolkit, Component component) {
        this.toolkit = toolkit;
        this.component = component;
        this.setBounds(component.getX(), component.getY(), component.getWidth(), component.getHeight(), 3);
    }

    @Override
    public void applyShape(Region r) {
    }

    @Override
    public boolean canDetermineObscurity() {
        return false;
    }

    public int checkImage(Image img, int w, int h, ImageObserver o) {
        return ((BDToolkit)this.toolkit).checkImage(img, w, h, o);
    }

    @Override
    public void coalescePaintEvent(PaintEvent e) {
    }

    @Override
    public void createBuffers(int x, BufferCapabilities bufferCapabilities) {
        logger.unimplemented("createBuffers");
    }

    public Image createImage(ImageProducer producer) {
        logger.unimplemented("createImage");
        return null;
    }

    @Override
    public Image createImage(int width, int height) {
        Container parent = this.component.getParent();
        if (parent != null) {
            return parent.createImage(width, height);
        }
        logger.error("createImage(): no parent !");
        throw new Error();
    }

    @Override
    public VolatileImage createVolatileImage(int width, int height) {
        logger.unimplemented("createVolatileImage");
        return null;
    }

    @Override
    public void destroyBuffers() {
    }

    public void disable() {
        this.setEnabled(false);
    }

    @Override
    public void dispose() {
        this.component = null;
        this.toolkit = null;
    }

    public void enable() {
        this.setEnabled(true);
    }

    @Override
    public void flip(int a, int b, int c, int d, BufferCapabilities.FlipContents e) {
    }

    public Rectangle getBounds() {
        return new Rectangle(this.location.x, this.location.y, this.size.width, this.size.height);
    }

    @Override
    public Image getBackBuffer() {
        logger.unimplemented("getBackBuffer");
        throw new Error();
    }

    @Override
    public ColorModel getColorModel() {
        return this.toolkit.getColorModel();
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        logger.unimplemented("getFontMetrics");
        return null;
    }

    @Override
    public Graphics getGraphics() {
        Graphics g;
        Container parent = this.component.getParent();
        if (parent != null && (g = parent.getGraphics()) != null) {
            return g.create(this.location.x, this.location.y, this.size.width, this.size.height);
        }
        logger.error("getGraphics(): no parent !");
        throw new Error();
    }

    @Override
    public GraphicsConfiguration getGraphicsConfiguration() {
        logger.unimplemented("getGraphicsConfiguration");
        return null;
    }

    @Override
    public Point getLocationOnScreen() {
        Point screen = new Point(this.location);
        Container parent = this.component.getParent();
        if (parent != null) {
            Point parentScreen = parent.getLocationOnScreen();
            screen.translate(parentScreen.x, parentScreen.y);
        }
        return screen;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.size;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.size;
    }

    public Toolkit getToolkit() {
        return this.toolkit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleEvent(AWTEvent e) {
        int id = e.getID();
        if (e instanceof PaintEvent) {
            Graphics g = null;
            Rectangle r = ((PaintEvent)e).getUpdateRect();
            try {
                g = this.component.getGraphics();
                if (g == null) {
                    return;
                }
                g.clipRect(r.x, r.y, r.width, r.height);
                if (id == 800) {
                    this.component.paint(g);
                } else {
                    this.component.update(g);
                }
                this.toolkit.sync();
            }
            finally {
                if (g != null) {
                    g.dispose();
                }
            }
        }
    }

    @Override
    public boolean handlesWheelScrolling() {
        return false;
    }

    public void hide() {
        this.setVisible(false);
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    @Override
    public boolean isObscured() {
        return false;
    }

    @Override
    public boolean isReparentSupported() {
        return false;
    }

    @Override
    public void layout() {
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    @Override
    public void paint(Graphics g) {
        this.component.paint(g);
    }

    public Dimension preferredSize() {
        return this.getPreferredSize();
    }

    public boolean prepareImage(Image img, int w, int h, ImageObserver o) {
        return ((BDToolkit)this.toolkit).prepareImage(img, w, h, o);
    }

    @Override
    public void print(Graphics g) {
    }

    public void repaint(long tm, int x, int y, int width, int height) {
        logger.unimplemented("repaint");
    }

    @Override
    public void reparent(ContainerPeer p) {
    }

    public void reshape(int x, int y, int width, int height) {
        this.setBounds(x, y, width, height, 3);
    }

    public boolean requestFocus(Component lightweightChild, boolean temporary, boolean focusedWindowChangeAllowed, long time) {
        return true;
    }

    @Override
    public void setBackground(Color c) {
    }

    @Override
    public void setBounds(int x, int y, int width, int height, int op) {
        this.location.x = x;
        this.location.y = y;
        this.size.width = width;
        this.size.height = height;
    }

    @Override
    public void setEnabled(boolean b) {
        logger.unimplemented("setEnabled");
    }

    @Override
    public void setFont(Font f) {
    }

    @Override
    public void setForeground(Color c) {
    }

    @Override
    public void setVisible(boolean b) {
    }

    @Override
    public void setZOrder(ComponentPeer peer) {
    }

    public void show() {
        this.setVisible(true);
    }

    @Override
    public void updateCursorImmediately() {
    }

    @Override
    public boolean updateGraphicsData(GraphicsConfiguration gc) {
        return false;
    }
}

